import type { Metadata } from "next";
import { Cairo } from "next/font/google";
import "./globals.css";
// import logo from "@/../public/images/logo.png";
import Header from "@/components/header/Header";
// import Navbar from "@/components/header/navbar/Navbar";
// import TopHeader from "@/components/header/top-header/TopHeader";
import Footer from "@/components/footer/Footer";
// import CallToAction from "@/components/call-to-action/CallToAction";

const cairo = Cairo({
  subsets: ["latin"],
  weight: ["400", "500", "600", "700", "800"],
});

export const metadata: Metadata = {
  title: "Shafted Abrasive Wheel - Blask Solutions",
  description: "Shafted Abrasive Wheel",
};

export default async function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="ar" dir="rtl">
      <body className={cairo.className}>
        <div className="page-height">
          <Header />
          {children}
        </div>
        <Footer />
      </body>
    </html>
  );
}
