import Image from "next/image";
import productImage from "../../public/images/productImage.jpeg";
import ProductOptions from "@/components/product-options/ProductOptions";

export default function Home() {
  return (
    <main>
      <section className="py-10">
        <div className="container">
          <div className="flex flex-col gap-10 lg:flex-row">
            <div className="grid aspect-square max-h-[400px] place-content-center rounded-md border p-4">
              <Image
                src={productImage}
                alt="صنفرة مقاس 30 * 60 - combi shafted wheel"
                className="max-size-full w-auto overflow-auto object-contain"
                priority
              />
            </div>
            <div className="">
              <h1 className="mb-3 text-xl capitalize lg:text-2xl lg:leading-normal">
                shafted abrasive wheel
              </h1>
              <ProductOptions />
            </div>
          </div>
        </div>
      </section>
    </main>
  );
}
